package com.ElyStudio.leGaou.activities;

import androidx.recyclerview.widget.LinearLayoutManager;

import android.os.Bundle;

import com.ElyStudio.leGaou.adapter.AppLanguageAdapter;
import com.ElyStudio.leGaou.databinding.ActivityChangeLanguageScreenBinding;
import com.ElyStudio.leGaou.models.AppLanguage;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.Constants;

import java.util.ArrayList;
import java.util.List;

public class ChangeLanguageScreen extends AppCompat {

    ActivityChangeLanguageScreenBinding binding;
    List<AppLanguage> appLanguageList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityChangeLanguageScreenBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        appLanguageList = new ArrayList<>();

        appLanguageList.add(new AppLanguage(Constants.hindiLanguage,Constants.hindiLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.englishLanguage,Constants.englishLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.arabicLanguage,Constants.arabicLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.frenchLanguage,Constants.frenchLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.russianLanguage,Constants.russianLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.germanLanguage,Constants.germanLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.vietnameseLanguage,Constants.vietnameseLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.italianLanguage,Constants.italianLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.indonesianLanguage,Constants.indonesianLanguageCode));
        appLanguageList.add(new AppLanguage(Constants.spanishLanguage,Constants.spanishLanguageCode));

        binding.appLanguagesRecyclerView.setLayoutManager(new LinearLayoutManager(ChangeLanguageScreen.this,LinearLayoutManager.VERTICAL,false));
        binding.appLanguagesRecyclerView.setAdapter(new AppLanguageAdapter(ChangeLanguageScreen.this,ChangeLanguageScreen.this,appLanguageList));
    }
}